Summary: 	Usenet newsserver for small sites
Name: 		noffle
Version: 	1.1.2
Release: 	1
Group: 		System Environment/Daemons
Copyright:	GPL
Packager:	Jim Hague <jim.hague@acm.org>
URL:		http://noffle.sourceforge.net
Buildroot:      %{_tmppath}/%{name}-root
Source:         http://prdownloads.sf.net/noffle/%{name}-%{version}.tar.gz
Requires:	gdbm
BuildRequires:  gdbm-devel
Conflicts:      inn

%define spooldir	%{_var}/spool/%{name}
%define cfgfiledir	%{_sysconfdir}
%define cfgfilename	%{cfgfiledir}/%{name}.conf

%description
NOFFLE is a news server optimized for low speed dialup connection to the
Internet and few users. It allows reading news offline with many news reader
programs, even if they do not support offline reading by themselves.

%prep
%setup -q

%build
%configure --enable-debug=no --with-configfile=%{cfgfilename} \
 --with-spooldir=%{spooldir}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

mkdir -p %{buildroot}%{_sysconfdir}{,/{cron.daily,xinetd.d}}
install packages/redhat/noffle-expire %{buildroot}%{_sysconfdir}/cron.daily/noffle
install packages/redhat/noffle-xinetd %{buildroot}%{_sysconfdir}/xinetd.d/noffle

ln -s noffle %{buildroot}%{_bindir}/inews

mv %{buildroot}%{_sysconfdir}/noffle.conf.example %{buildroot}%{_sysconfdir}/noffle.conf

%post
if [ -f /etc/hosts.deny ] && ! grep -q '^[# \t]*noffle' /etc/hosts.deny ; then
	echo >> /etc/hosts.deny
	echo "noffle: ALL EXCEPT LOCAL" >> /etc/hosts.deny
fi
echo
echo " Don't forget to edit %{cfgfilename} !!! "
echo

%postun
# The script gets 0 on uninstall, 1 on upgrade. Don't remove
# hosts.deny/inetd.conf lines on upgrade.
if [ "$1" = 0 ] ; then
	if [ -f /etc/hosts.deny ] &&
	   grep noffle /etc/hosts.deny > /dev/null 2>&1 ; then
		if grep -v noffle /etc/hosts.deny > /tmp/hosts.deny.$$ ; then
			mv -f /tmp/hosts.deny.$$ /etc/hosts.deny
		fi
	fi
fi

%clean
[ "$RPM_BUILD_ROOT" != "" ] && rm -rf $RPM_BUILD_ROOT

%files

%defattr(-,root,root)
%doc README INSTALL ChangeLog docs/FAQ docs/NOTES docs/INTERNALS
%doc docs/noffle.lsm
%attr(0644,root,root)	%config(noreplace) %{_sysconfdir}/xinetd.d/noffle
%{_bindir}/inews
%defattr(-,news,news)
%attr(4755,news,news)	%{_bindir}/noffle
%attr(0644,root,root)	%doc %{_mandir}/man*/noffle*
%attr(0600,news,news)	%config(noreplace) %{cfgfilename}
%attr(0755,news,news)	%config(noreplace) %{_sysconfdir}/cron.daily/noffle
%attr(2755,news,news)	%dir %{spooldir}
%attr(0755,news,news)	%dir %{spooldir}/data
%attr(0755,news,news)	%dir %{spooldir}/lock
%attr(0755,news,news)	%dir %{spooldir}/requested
%attr(0755,news,news)	%dir %{spooldir}/outgoing
%attr(0755,news,news)	%dir %{spooldir}/overview

%changelog
* Fri Mar 15 2002 Jim Hague <jim.hague@acm.org>
- Revamp spec file, making use of the first version Mandrake spec file
  by Alexander Skwar <ASkwar@Linux-Mandrake.com>.
- Make noffle-expire just plain /etc/cron.daily/noffle.
- Version 1.1.2-1 RPM

* Sun Jan 13 2002 Jim Hague <jim.hague@acm.org>
- Incorporate changes from Carles Arjona <nospammer@bigfoot.com>
- Version 1.1.1-2 RPM
- Added support for xinetd
- Separated noffle.expire from the original tarball sources

* Wed Oct 31 2001 Jim Hague <jim.hague@acm.org>
- Up version to 1.1-1, and remove inews from %files as it is created by %post.
  Remove relocation prefix - it wasn't working properly. Also
  RPM 4 seems to automatically compress man pages, so put man pages in
  %files as /usr/man/* so we pick up whatever is there, compressed or not.

* Thu Oct 26 2000 Jim Hague <jim.hague@am.org>
- Added inews link.

* Sun Jun 18 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-3 RPM
- Changed /etc/noffle.conf mode to 0600 in case server password is required
- Added noffle line to /etc/hosts.deny
- Make inetd.conf handling match linuxconf - don't keep old files and only
  add entries if nntp line is not already present, even if commented out,
  and only remove conf lines on an uninstall

* Fri Jun 16 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-2 RPM
- Added /etc/cron.daily/noffle-expire

* Thu Jun 15 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-1 RPM
- Modified SPEC from 1.0pre5

* Wed May 17 2000 Soenke J. Peters <peters+rpm@simprovement.com>
- Version 1.0pre5-1 RPM
- built SPEC from scratch

* Mon Aug 23 1999 Mario Moder <moderm@gmx.net>
- Version 1.0pre2-1 Binary only RPM, no SPEC available
