/*
  post.h

  Take the text of a single article, parse it and add/amend headers as
  necessary, and add to the local database and/or queue for external
  posting as appropriate.

  $Id: post.h 227 2000-10-26 21:21:13Z bears $
*/

#ifndef POST_H
#define POST_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"

/* Flags for Post_open */
#define	POST_ADD_ORG		0001
#define	POST_DEBUG		0002
#define	POST_ADD_SIG		0004
#define	POST_ADD_FROM		0010

/* Register an article for posting. */
Bool
Post_open( const char * text, unsigned flags );

/* Post the article. */
Bool
Post_post( void );
   
/* Done with article - tidy up. */
void
Post_close( void );

#endif
