/*
  common.h

  Common declarations.

  $Id: common.h 382 2002-06-05 22:03:44Z mirkol $
*/

#ifndef COMMON_H
#define COMMON_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define FALSE 0
#define TRUE !0
#define MAXCHAR 2048
/* limited sscanf() format string: */
#define MAXCHAR_FMT "%2048s"

#ifdef DEBUG
#include <assert.h>
#define ASSERT( x ) \
    if ( ! ( x ) ) \
        Log_err( "ASSERTION FAILED: %s line %i", __FILE__, __LINE__ ); \
    assert( x )
#else
#define ASSERT( x )
#endif

typedef int Bool;
typedef char Str[ MAXCHAR ];

#endif
