/*
  client.h

  Noffle acting as client to other NNTP-servers

  $Id: client.h 49 2000-05-05 21:45:56Z uh1763 $
*/

#ifndef CLIENT_H
#define CLIENT_H

#include <time.h>
#include "common.h"
#include "database.h"
#include "fetchlist.h"

/* Format of server name: <host>[:<port>] */
Bool
Client_connect( const char *serv );

void
Client_disconnect( void );

Bool
Client_getGrps( void );

Bool
Client_getDsc( void );

Bool
Client_getCreationTimes( void );

Bool
Client_getNewgrps( const time_t *lastTime );

/*
  Change to group <name> at server if it is also in current local grouplist.
  Returns TRUE at success.
*/
Bool
Client_changeToGrp( const Str name );

/*
  Get overviews <rmtFirst> - <rmtLast> from server and append it
  to the current content. For articles that are to be fetched due to FULL
  or THREAD mode, store IDs in request database.
*/
Bool
Client_getOver( int rmtFirst, int rmtLast, FetchMode mode );

/*
  Retrieve full article text and store it into database.
*/
void
Client_retrieveArt( const char *msgId );

/*
  Same, but for a list of msgId's (new line after each msgId).
  All ARTICLE commands are sent and then all answers read.
*/
void
Client_retrieveArtList( const char *list );

/*
  Store IDs of first and last article of group selected by
  Client_changeToGroup at remote server. 
*/
void
Client_rmtFirstLast( int *first, int *last );

Bool
Client_postArt( const char *msgId, const char *artTxt, Str errStr );

#endif
