/*
  outgoing.h

  Collection of posted articles.

  $Id: outgoing.h 49 2000-05-05 21:45:56Z uh1763 $
*/

#ifndef OUT_H
#define OUT_H

#include "common.h"
#include "dynamicstring.h"

Bool
Out_add( const char *serv, const char *msgId, const DynStr *artTxt );

/* Start enumeration. Return TRUE on success. */
Bool
Out_first( const char *serv, Str msgId, DynStr *artTxt );

/* Continue enumeration. Return TRUE on success. */
Bool
Out_next( Str msgId, DynStr *s );

/* Delete article from outgoing collection */
void
Out_remove( const char *serv, const char *msgId );

/* Find server for outgoing message. */
Bool
Out_find( const char *msgId, Str server );

#endif
