/*
  itemlist.c

  $Id: itemlist.c 51 2000-05-05 23:49:38Z uh1763 $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "itemlist.h"
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "common.h"
#include "log.h"

struct ItemList
{
    char *list;
    char *separators;
    char *next;
    size_t count;
};

/* Make a new item list. */
ItemList *
new_Itl( const char *list, const char *separators )
{
    ItemList * res;
    char *p;
    Bool inItem;

    res = malloc( sizeof( ItemList ) );
    if ( res == NULL )
    {
	Log_err( "Malloc of ItemList failed." );
	exit( EXIT_FAILURE );
    }
    
    res->list = malloc ( strlen(list) + 2 );
    if ( res->list == NULL )
    {
	Log_err( "Malloc of ItemList.list failed." );
	exit( EXIT_FAILURE );
    }
    strcpy( res->list, list );

    if (  ( res->separators = strdup( separators ) ) == NULL )
    {
	Log_err( "Malloc of ItemList.separators failed." );
	exit( EXIT_FAILURE );
    }

    res->count = 0;
    res->next = res->list;

    /* Separate items into strings and have final zero-length string. */
    for( p = res->list, inItem = FALSE; *p != '\0'; p++ )
    {
	Bool isSep = ( strchr( separators, p[ 0 ] ) != NULL );
	
	if ( inItem )
	{
	    if ( isSep )
	    {
		p[ 0 ] = '\0';
		inItem = FALSE;
		res->count++;
	    }
	}
	else
	{
	    if ( ! isSep )
		inItem = TRUE;
	}
    }
    if ( inItem )
	res->count++;
    p[ 1 ] = '\0';
    return res;
}

/* Delete an item list. */
void
del_Itl( ItemList *self )
{
    if ( self == NULL )
	return;
    free( self->list );
    free( self->separators );
    free( self );
}

/* Get first item. */
const char *
Itl_first( ItemList *self)
{
    self->next = self->list;
    return Itl_next( self );
}

/* Get next item or NULL. */
const char *
Itl_next( ItemList *self )
{
    const char *res = self->next;

    if ( res[ 0 ] == '\0' )
	return NULL;

    while ( strchr( self->separators, res[ 0 ] ) != NULL )
	res++;

    if ( res[ 0 ] == '\0' && res[ 1 ] == '\0' )
	return NULL;

    self->next += strlen( res ) + 1;
    return res;
}

/* Get count of items in list. */
size_t
Itl_count( const ItemList *self )
{
    return self->count;
}
