/*
  lock.h

  Opening/Closing of the various databases: article overview database,
  articla database, groups database, outgoing articles database, requests
  database. Handles global lock.

  $Id: lock.h 183 2000-07-25 12:14:54Z bears $
*/

#ifndef LOCK_H
#define LOCK_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"

enum LockRequestWait { LOCK_WAIT, LOCK_NOWAIT };

/* Open all databases and set global lock. */
Bool
Lock_openDatabases( void );

/* Close all databases and release global lock. */
void
Lock_closeDatabases( void );

/* Check the global lock held. */
Bool
Lock_gotLock( void );

/* Get fetch lock. */
Bool
Lock_getFetchLock( enum LockRequestWait wait );

/* Release fetch lock. */
void
Lock_releaseFetchLock( void );

/* Check the fetch lock held. */
Bool
Lock_fetchLock( void );

#endif
