/*
  portable.h

  Compatibility checks and fallback-functions.

  $Id: portable.h 61 2000-05-09 22:32:33Z uh1763 $
*/

#ifndef PORTABLE_H
#define PORTABLE_H    /* To stop multiple inclusions. */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !defined(HAVE_VSNPRINTF) && defined(HAVE___VSNPRINTF)
#undef vsnprintf
#define vsnprintf __vsnprintf
#define HAVE_VSNPRINTF
#endif

/* This is *not* good, because vsprintf() doesn't do any bounds-checking */
#if !defined(HAVE_VSNPRINTF) && !defined(HAVE___VSNPRINTF)
#define vsnprintf(c, len, fmt, args) vsprintf(c, fmt, args)
#define HAVE_VSNPRINTF
#endif

#if !defined(HAVE_SNPRINTF) && defined(HAVE___SNPRINTF)
#undef snprintf
#define snprintf __snprintf
#define HAVE_SNPRINTF
#endif


#endif

