Summary: 	Usenet newsserver for small sites
Name: 		noffle
Version: 	1.1.1
Release: 	1
Group: 		Networking/Daemons
Copyright:	GPL
Packager:	Carles Arjona <nospammer@bigfoot.com>
URL:		http://noffle.sourceforge.net
BuildRoot:	/var/tmp/%{name}-%{version}-root
Source: http://prdownloads.sourceforge.net/noffle/%{name}-%{version}.tar.gz
Source1:	noffle-expire
Requires:	gdbm

%description
NOFFLE is a news server optimized for low speed dialup connection to the
Internet and few users. It allows reading news offline with many news reader
programs, even if they do not support offline reading by themselves.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s"
export CFLAGS LDFLAGS
./configure --prefix=/usr --enable-debug=no --mandir=%{_mandir} \
 --with-docdir=%{_docdir}
make

%install
install -o 0 -g 0 -d $RPM_BUILD_ROOT%{_bindir}
install -s -m 4755 -o news -g news src/noffle $RPM_BUILD_ROOT%{_bindir}
install -o 0 -g 0 -d $RPM_BUILD_ROOT%{_mandir}/man1
install -m 0644 -o 0 -g 0 docs/noffle.1 $RPM_BUILD_ROOT%{_mandir}/man1/noffle.1
install -o 0 -g 0 -d $RPM_BUILD_ROOT%{_mandir}/man5
install -m 0644 -o 0 -g 0 docs/noffle.conf.5 $RPM_BUILD_ROOT%{_mandir}/man5/noffle.conf.5
install -m 2755 -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/data
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/lock
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/requested
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/outgoing
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/overview
install -o 0 -g 0 -d $RPM_BUILD_ROOT/etc/cron.daily
install -m 0755 -o news -g news $RPM_SOURCE_DIR/noffle-expire $RPM_BUILD_ROOT/etc/cron.daily/noffle-expire
install -m 0600 -o news -g news noffle.conf.example $RPM_BUILD_ROOT/etc/noffle.conf

%post
# Create inews line
ln -sf %{_bindir}/noffle %{_bindir}/inews
# Update /etc/inetd.conf
if ! grep -q '^[# \t]*nntp' /etc/inetd.conf ; then
	echo >> /etc/inetd.conf
	echo "nntp stream tcp nowait news /usr/sbin/tcpd usr/bin/noffle -r" >> /etc/inetd.conf
        if [ -f /var/run/inetd.pid ] ; then
                kill -HUP `cat /var/run/inetd.pid`
        fi
fi
# xinetd configuration file
if [ -d /etc/xinetd.d ]; then
    cat << END > /etc/xinetd.d/nntp
# default: on
# description: The noffle news server serves NNTP connections.
service nntp
{
        disable = no
        socket_type             = stream
        protocol                = tcp
        wait                    = no
        user                    = news
        server                  = %{_bindir}/noffle
        server_args             = -r
}
END
fi
if ! grep -q '^[# \t]*noffle' /etc/hosts.deny ; then
	echo >> /etc/hosts.deny
	echo "noffle: ALL EXCEPT LOCAL" >> /etc/hosts.deny
fi
echo
echo " Don't forget to edit /etc/noffle.conf !!! "
echo

%postun
# The script gets 0 on uninstall, 1 on upgrade. Don't remove
# hosts.deny/inetd.conf lines on upgrade.
rm /usr/bin/inews
if [ "$1" = 0 ] ; then
	if [ -f /etc/inetd.conf ] &&
	   grep noffle /etc/inetd.conf > /dev/null 2>&1 ; then
		if grep -v noffle /etc/inetd.conf > /tmp/inetd.$$ ; then
			mv -f /tmp/inetd.$$ /etc/inetd.conf
        		if [ -f /var/run/inetd.pid ] ; then
                		kill -HUP `cat /var/run/inetd.pid`
        		fi
		fi
	fi
	if [ -f /etc/xinetd.d/nntp ]; then
	   rm -f /etc/xinetd.d/nntp
	fi
	if [ -f /etc/hosts.deny ] &&
	   grep noffle /etc/hosts.deny > /dev/null 2>&1 ; then
		if grep -v noffle /etc/hosts.deny > /tmp/hosts.deny.$$ ; then
			mv -f /tmp/hosts.deny.$$ /etc/hosts.deny
		fi
	fi
fi

%clean
[ "$RPM_BUILD_ROOT" != "" ] && rm -rf $RPM_BUILD_ROOT

%files
%config(noreplace) /etc/noffle.conf
%doc README INSTALL ChangeLog docs/FAQ docs/NOTES docs/INTERNALS
%doc docs/noffle.lsm COPYING noffle.conf.example
%{_bindir}/noffle
%{_mandir}/man?/*
/etc/cron.daily/noffle-expire
%dir /var/spool/noffle
%dir /var/spool/noffle/*

%changelog
* Sun Jan 13 2002 Jim Hague <jim.hague@acm.org>
- Incorporate changes from Carles Arjona <nospammer@bigfoot.com>
- Version 1.1.1-2 RPM
- Added support for xinetd
- Separated noffle.expire from the original tarball sources

* Wed Oct 31 2001 Jim Hague <jim.hague@acm.org>
- Up version to 1.1-1, and remove inews from %files as it is created by %post.
  Remove relocation prefix - it wasn't working properly. Also
  RPM 4 seems to automatically compress man pages, so put man pages in
  %files as /usr/man/* so we pick up whatever is there, compressed or not.

* Thu Oct 26 2000 Jim Hague <jim.hague@am.org>
- Added inews link.

* Sun Jun 18 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-3 RPM
- Changed /etc/noffle.conf mode to 0600 in case server password is required
- Added noffle line to /etc/hosts.deny
- Make inetd.conf handling match linuxconf - don't keep old files and only
  add entries if nntp line is not already present, even if commented out,
  and only remove conf lines on an uninstall

* Fri Jun 16 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-2 RPM
- Added /etc/cron.daily/noffle-expire

* Thu Jun 15 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-1 RPM
- Modified SPEC from 1.0pre5

* Wed May 17 2000 Soenke J. Peters <peters+rpm@simprovement.com>
- Version 1.0pre5-1 RPM
- built SPEC from scratch

* Mon Aug 23 1999 Mario Moder <moderm@gmx.net>
- Version 1.0pre2-1 Binary only RPM, no SPEC available
