/*
  client.h

  Noffle acting as client to other NNTP-servers

  $Id: client.h 307 2001-09-12 20:33:44Z bears $
*/

#ifndef CLIENT_H
#define CLIENT_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "common.h"
#include "database.h"
#include "fetchlist.h"

/*
  Status values returned by client routines. These will be NNTP status
  values or the two below, which are not valid NNTP result codes.
 */
#define STAT_OK                 0
#define STAT_CONNECTION_LOST    (-1)
#define	STAT_NEWSBASE_FATAL	(-2)

#define IS_FATAL(stat)      	(stat < 0)

/* Format of server name: <host>[:<port>] */
Bool
Client_connect( const char *serv );

void
Client_disconnect( void );

int
Client_getGrps( void );

int
Client_getDsc( void );

int
Client_getNewgrps( const time_t *lastTime );

/*
  Change to group <name> at server if it is also in current local grouplist.
  Returns TRUE at success.
*/
int
Client_changeToGrp( const Str name );

/*
  Get overviews <rmtFirst> - <rmtLast> from server and append it
  to the current content. For articles that are to be fetched due to FULL
  or THREAD mode, store IDs in request database.
*/
int
Client_getOver( const char *grp, int rmtFirst, int rmtLast, FetchMode mode );

/*
  Retrieve full article text and store it into database.
*/
int
Client_retrieveArt( const char *msgId );

/*
  Same, but for a list of msgId's (new line after each msgId).
  All ARTICLE commands are sent and then all answers read.
*/
int
Client_retrieveArtList( const char *list, int *artcnt, int artmax );

/*
  Store IDs of first and last article of group selected by
  Client_changeToGroup at remote server. 
*/
void
Client_rmtFirstLast( int *first, int *last );

int
Client_postArt( const char *msgId, const char *artTxt, Str errStr );

#endif
