;; Customising Gnus for use with the NOFFLE news server
;; 
;;  tick and open article
;;          for reading/marking for download
;;   scroll article text circular
;;          for avoiding automatic opening of next article
;;       mark article as read and go to next line
(defun my-gnus-summary-tick-and-open(n)
  "Tick and open article, so that NOFFLE marks it for download" 
  (interactive "p")
  (gnus-summary-scroll-up n)
  (gnus-summary-mark-article nil gnus-ticked-mark t)
  )
(defun my-gnus-summary-next-page(n)
  "Next page of article, but do not open next article automatically"
  (interactive "p")
  (gnus-summary-next-page 10 t) ;; Call with argument `circular'.
  )
(defun my-gnus-summary-mark-read-next-line(n)
  "Mark article as read and go to next line"
  (interactive "p")
  (gnus-summary-mark-article-as-read gnus-read-mark)
  (next-line n)
  )
(defun my-gnus-summary-mode-hook ()
  (define-key gnus-summary-mode-map "\r"
    'my-gnus-summary-tick-and-open)
  (define-key gnus-summary-mode-map " "
    'my-gnus-summary-next-page)
  (define-key gnus-summary-mode-map "d"
    'my-gnus-summary-mark-read-next-line)
  )
(add-hook 'gnus-summary-mode-hook 'my-gnus-summary-mode-hook)
