/*
  dynamicstring.h

  String utilities

  $Id: dynamicstring.h 49 2000-05-05 21:45:56Z uh1763 $
*/

#ifndef DYNAMICSTRING_H
#define DYNAMICSTRING_H

#include <sys/types.h>

/* A dynamically growing string */
struct DynStr;
typedef struct DynStr DynStr;

/* Create new DynStr with given capacity */
DynStr *
new_DynStr( size_t reserve );

/* Delete DynStr */
void
del_DynStr( DynStr *self );

/* Return DynStr's length */
size_t
DynStr_len( const DynStr *self );

/* Return DynStr's content ptr */
const char *
DynStr_str( const DynStr *self );

/* append C-string to DynStr */
void
DynStr_app( DynStr *self, const char *s );

/* append a DynStr to DynStr */
void
DynStr_appDynStr( DynStr *self, const DynStr *s );

/* Append C-string + newline to DynStr */
void
DynStr_appLn( DynStr *self, const char *s );

/* Append a maximum of n characters from C-string s to DynStr self */
void
DynStr_appN( DynStr *self, const char *s, size_t n );

/* Truncate content of DynString to zero length */
void
DynStr_clear( DynStr *self );

#endif
