/*
  post.h

  Take the text of a single article, parse it and add/amend headers as
  necessary, and add to the local database and/or queue for external
  posting as appropriate.

  $Id: post.h 100 2000-05-18 12:17:23Z bears $
*/

#ifndef POST_H
#define POST_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"

/* Register an article for posting. */
Bool
Post_open( const char * text );

/*
  Post the article. If localOnly, article is only posted to local
  groups, and is posted regardless of group posting status.
 */
Bool
Post_post( Bool localOnly );
   
/* Done with article - tidy up. */
void
Post_close( void );

#endif
