Summary: 	Usenet newsserver for small sites
Name: 		noffle
Version: 	1.0pre6
Release: 	4
Group: 		Networking/Daemons
Copyright:	GPL
Packager:	Soenke J. Peters <peters+rpm@simprovement.com>
URL:		http://home.t-online.de/home/markus.enzenberger/noffle.html
BuildRoot:	/var/tmp/%{name}-%{version}-root
Source: http://download.sourceforge.net/noffle/%{name}-%{version}.tar.gz
Prefix:		/usr

Requires:	gdbm
Requires:	mailx
Requires:	textutils

%description
NOFFLE is a news server optimized for low speed dialup connection to the
Internet and few users. It allows reading news offline with many news reader
programs, even if they do not support offline reading by themselves.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s"
export CFLAGS LDFLAGS
./configure --prefix=/usr --enable-debug=no
make

%install
install -o 0 -g 0 -d $RPM_BUILD_ROOT/%{prefix}/bin
install -s -m 4755 -o news -g news src/noffle $RPM_BUILD_ROOT/%{prefix}/bin
install -o 0 -g 0 -d $RPM_BUILD_ROOT/%{prefix}/man/man1
install -m 0644 -o 0 -g 0 docs/noffle.1 $RPM_BUILD_ROOT/%{prefix}/man/man1/noffle.1
install -o 0 -g 0 -d $RPM_BUILD_ROOT/%{prefix}/man/man5
install -m 0644 -o 0 -g 0 docs/noffle.conf.5 $RPM_BUILD_ROOT/%{prefix}/man/man5/noffle.conf.5
install -m 2755 -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle
install -o 0 -g 0 -d $RPM_BUILD_ROOT/etc
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/data
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/lock
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/requested
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/outgoing
install -o news -g news -d $RPM_BUILD_ROOT/var/spool/noffle/overview
install -m 0600 -o news -g news noffle.conf.example $RPM_BUILD_ROOT/etc/noffle.conf
install -o 0 -g 0 -d $RPM_BUILD_ROOT/etc/cron.daily
install -m 0755 -o news -g news packages/redhat/noffle-expire $RPM_BUILD_ROOT/etc/cron.daily/noffle-expire

%post
# Update /etc/inetd.conf
if ! grep -q '^[# \t]*nntp' /etc/inetd.conf ; then
	echo >> /etc/inetd.conf
	echo "nntp stream tcp nowait news /usr/sbin/tcpd %{prefix}/bin/noffle -r" >> /etc/inetd.conf
        if [ -f /var/run/inetd.pid ] ; then
                kill -HUP `cat /var/run/inetd.pid`
        fi
fi
if ! grep -q '^[# \t]*noffle' /etc/hosts.deny ; then
	echo >> /etc/hosts.deny
	echo "noffle: ALL EXCEPT LOCAL" >> /etc/hosts.deny
fi
echo
echo " Don't forget to edit /etc/noffle.conf !!! "
echo

%postun
# The script gets 0 on uninstall, 1 on upgrade. Don't remove
# hosts.deny/inetd.conf lines on upgrade.
if [ "$1" = 0 ] ; then
	if [ -f /etc/inetd.conf ] &&
	   grep noffle /etc/inetd.conf > /dev/null 2>&1 ; then
		if grep -v noffle /etc/inetd.conf > /tmp/inetd.$$ ; then
			mv -f /tmp/inetd.$$ /etc/inetd.conf
        		if [ -f /var/run/inetd.pid ] ; then
                		kill -HUP `cat /var/run/inetd.pid`
        		fi
		fi
	fi
	if [ -f /etc/hosts.deny ] &&
	   grep noffle /etc/hosts.deny > /dev/null 2>&1 ; then
		if grep -v noffle /etc/hosts.deny > /tmp/hosts.deny.$$ ; then
			mv -f /tmp/hosts.deny.$$ /etc/hosts.deny
		fi
	fi
fi

%clean
[ "$RPM_BUILD_ROOT" != "" ] && rm -rf $RPM_BUILD_ROOT

%files
%config /etc/noffle.conf
%doc README INSTALL ChangeLog docs/FAQ docs/NOTES docs/INTERNALS docs/noffle.lsm COPYING noffle.conf.example
%{prefix}/bin/noffle
%{prefix}/man/man1/noffle.1
%{prefix}/man/man5/noffle.conf.5
/etc/cron.daily/noffle-expire
%dir /var/spool/noffle
%dir /var/spool/noffle/data
%dir /var/spool/noffle/lock
%dir /var/spool/noffle/requested
%dir /var/spool/noffle/outgoing
%dir /var/spool/noffle/overview

%changelog
* Sun Jun 18 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-3 RPM
- Changed /etc/noffle.conf mode to 0600 in case server password is required
- Added noffle line to /etc/hosts.deny
- Make inetd.conf handling match linuxconf - don't keep old files and only
  add entries if nntp line is not already present, even if commented out,
  and only remove conf lines on an uninstall

* Fri Jun 16 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-2 RPM
- Added /etc/cron.daily/noffle-expire

* Thu Jun 15 2000 Jim Hague <jim.hague@am.org>
- Version 1.0pre6-1 RPM
- Modified SPEC from 1.0pre5

* Wed May 17 2000 Soenke J. Peters <peters+rpm@simprovement.com>
- Version 1.0pre5-1 RPM
- built SPEC from scratch

* Mon Aug 23 1999 Mario Moder <moderm@gmx.net>
- Version 1.0pre2-1 Binary only RPM, no SPEC available
