/*
  configfile.h

  Common declarations and handling of the configuration file.

  $Id: configfile.h 155 2000-06-24 20:28:01Z bears $
*/

#ifndef CONFIGFILE_H
#define CONFIGFILE_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"

struct GroupEnum;
typedef struct GroupEnum GroupEnum;

const char * Cfg_spoolDir( void );
const char * Cfg_version( void );

int Cfg_maxFetch( void );
int Cfg_autoUnsubscribeDays( void );
int Cfg_threadFollowTime( void );
int Cfg_connectTimeout( void );
Bool Cfg_autoUnsubscribe( void );
Bool Cfg_autoSubscribe( void );
Bool Cfg_infoAlways( void );

Bool Cfg_replaceMsgId( void );
Bool Cfg_postLocal( void );
const char * Cfg_mailTo( void );

/* Begin iteration through the server names */
void Cfg_beginServEnum( void );

/* Save next server name in "name". Return TRUE if name has been was saved.
   Return FALSE if there are no more server names. */
Bool Cfg_nextServ( Str name );

Bool Cfg_servListContains( const char *name );
/* Prefer server earlier in config file. Known servers are always preferential
   to unknown servers. */
Bool Cfg_servIsPreferential( const char *name1, const char *name2 );
void Cfg_authInfo( const char *name, Str user, Str pass );

/* Return expire period for named group. */
int Cfg_expire( const char *grp );

/* Return default expire days. */
int Cfg_defaultExpire( void );

/* Return auto subscribe mode for named group. Can be: full, thread, over */
const char * Cfg_autoSubscribeMode( const char *grp );

/* Return default auto subscribe mode. Can be: full, thread, over */
const char * Cfg_defaultAutoSubscribeMode( void );

/* Return Path: header contents */
const char * Cfg_pathHeader( void );

void Cfg_read( void );

/* Get a new iterator for get group patterns for the given server */
GroupEnum *
new_GetGrEn( const char *name );

/* Get a new iterator for omit group patterns for the given server */
GroupEnum *
new_OmitGrEn( const char *name );

/* Free up a group enumerator */
void
del_GrEn( GroupEnum * ge );

/* Rewind to first group */
void
GrEn_first( GroupEnum * ge );

/* Get next group pattern or NULL if no more */
const char *
GrEn_next( GroupEnum *ge );

#endif
