/*
  log.h

  Print log messages to syslog, stdout/stderr.

  $Id: log.h 413 2002-12-27 21:48:25Z bears $
*/

#ifndef LOG_H
#define LOG_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"

/*
  Debug logging subsystem identifiers. Can be ORd together.
  Debug logging can be turned on in the configuration file;
  by default it is off.
*/
#define	LOG_DBG_CONFIG		(0x0001)
#define	LOG_DBG_CONTROL		(0x0002)
#define	LOG_DBG_EXPIRE		(0x0004)
#define	LOG_DBG_FETCH		(0x0008)
#define	LOG_DBG_FILTER		(0x0010)
#define	LOG_DBG_NEWSBASE	(0x0020)
#define	LOG_DBG_NOFFLE		(0x0040)
#define	LOG_DBG_POST		(0x0080)
#define	LOG_DBG_PROTOCOL	(0x0100)
#define	LOG_DBG_REQUESTS	(0x0200)
#define	LOG_DBG_SERVER		(0x0400)
#define	LOG_DBG_AUTH		(0x0800)

#define	LOG_DBG_ALL		(0xffff)
#define	LOG_DBG_NONE		(0x0000)

/*
  Initialise logging (required before using any log functions).
  name: program name for syslog
  interactive: print messages also to stderr/stdout
  facility: like syslog
*/
void
Log_init( const char *name, Bool interactive, int facility );

/* Log level info */
void
Log_inf( const char *fmt, ... );

/* Log level error */
void
Log_err( const char *fmt, ... );

/* Check for cond being true. Otherwise log an error, and return 1. */
int 
Log_check( int cond, const char *fmt, ... );

/* Log level notice */
void
Log_ntc( const char *fmt, ... );

/* Log level debug on indicated subsystem */
void
Log_dbg( unsigned subsystem, const char *fmt, ... );

/* Set debug log mask */
void
Log_setDbgMask( unsigned mask );

/* Fatal error */
void
Log_fatal( const char *fmt, ... );

/* Fatal error in gdbm */
void
Log_gdbm_fatal( const char *msg );

#endif
